# Digital Diode Laser Controller

## v1.15.0 - 2025-05-26
- Implemented extremely slow sweeps, period up to 10 minutes


## v1.14.1 - 2025-05-15
- Allow OFFSET and SPAN to be modified programmatically while locked without having immediate effect
- Changed unlock behaviour to no longer automatically restore OFFSET
- Fixed reset of TEC gains to default values


## v1.13.12 - 2025-05-07
- Added support for new hardware revisions


## v1.13.11 - 2025-05-06
- Changed TEC to preserve integrator value when toggling keyswitch to prevent temperature impulse


## v1.13.10 - 2025-05-02
- Implemented rapid SLOW,FOLLOW correction to follow changing wavemeter PID lock setpoint
- Added SLOW,BIAS command to enable bias current when locked to avoid mode-hop when adjusting setpoint
- Introduced hysteresis on SLOW,FOLLOW behaviour to prevent oscillation at boundary


## v1.13.8 - 2025-05-01
- Implemented rapid SLOW,FOLLOW correction to follow changing wavemeter PID lock setpoint
- Added SLOW,BIAS command to enable bias current when locked to avoid mode-hop when adjusting setpoint


## v1.13.7 - 2025-04-30
- Implemented FPBLOCK command for optionally locking front-panel encoders to prevent accidental adjustment


## v1.13.5 - 2025-04-14
- Fixed rare scenario causing front-panel LEDs to become desynchronised with device state
- Fixed AUX input selection for "EXT_SLOW" lock mode
- Implemented SLOW,FOLLOW behaviour by default for EXT_SLOW lock mode to extend wavemeter PID lock range


## v1.13.4 - 2025-03-24
- Resolved potential floating point error accumulation in TEC controller
- Improved TEC controller deadband handling
- Fixed incorrect automatic reduction of master TEC gain


## v1.13.3 - 2025-03-12
- Implemented custom TEC PID constants in EEPROM
- Fixed implementation of TEC KD term


## v1.13.2 - 2025-03-11
- Increased max TEC rate of change to 50C/min
- Increased max permitted TEC PCB temperature to 70C
- Improved TEC handling of step change when changing emission state
- Improved zero-crossing check on reaching setpoint temperature
- Improved bounds on automatic TEC gain adjustment


## v1.13.1 - 2025-03-04
- Implemented automatic gain reduction for TEC master gain
- Improved susceptibility of TEC controller to oscillation


## v1.13.0 - 2025-03-03
- Introduced master gain (KM) for improved behaviour across different TEC systems
- Fixed scenario that could cause TEC to settle at wrong temperature
- Fixed check for TEC open circuit
- Reduced minimum TEC,ILIM to 10mA for very sensitive systems
- Require at least 1degC margin between setpoint temperature and temperature limits
- Fixed PCB temperature lookup table for B1180R3+


## v1.12.9 - 2025-02-19
- Check for keyswitch state when enabling TEC
- Consolidated EEPROM handling around reboot operations
- Fixes to "auto phase" and "auto offset" functions at slow sweep rates


## v1.12.8 - 2025-02-05
- Improvements to incompatibility detection at system boot.


## v1.12.7 - 2025-01-29
- Improvements to low-level networking library to handle socket exhaustion.
- Addressed scenario where front-panel LEDs might show incorrect state.
- Adjusted AUTO capture window selection.


## v1.12.6 - 2025-01-28
- Improvements to robustness of `PDOFFSET,AUTO`.
- Fixed regression when specifying fixed voltage for `PDOFFSET`.
- Fixed clearing error state when unlocking laser.
- Fixed automatic selection of `LOCK,SRC` when setting `LOCK,MODE`
- Improvements to handling of factory reset EEPROM.


## v1.12.5 - 2025-01-16
- Replaced references to AUX1/AUX2 with AUX_A/AUX_B as appropriate.
- Improvements to communications with front-panel OSD.


## v1.12.3 - 2025-01-13
- Significant improvements to stability of TEC controller in many scenarios.
- Clarified error message for `PDOFFSET,AUTO` when sweep rate too low.
- Increased threshold for "LOCK FAILED" warning to 0.98.
- Support for B1150R5 hardware.


## v1.12.0 - 2024-12-20
- Improved TEC controller overshoot upon reaching setpoint temperature.
- Fixed issue that could cause front-panel LEDs to not represent device state.
- Improved handling of "AUTO" timebase in oscilloscope mode.
- Support for B1190R5 hardware.


## v1.11.6 - 2024-12-17
- Improved handling of low sweep rates (under 5 Hz).
- Modified minimum supported sweep rate to 0.02 Hz.
- Perform interpolation when changing SPAN/OFFSET to avoid step changes.
- Added timestamp logging of lock warnings.


## v1.11.4 - 2024-12-16
- Improved handling of laser compliance voltage headroom.
- Improved smoothness of front-panel SPAN encoder when operating at large span.


## v1.11.3 - 2024-12-13
- Migrate default TEC controller gain settings to improve performance on earlier units.


## v1.11.2 - 2024-12-10
- Improved compliance voltage handling for B1150R4 hardware.


## v1.11.1 - 2024-12-04
- Added support for headboard ambient pressure sensor, where available.
- Fixed automatic phase and offset optimisation features.
- Improved handling of timeout scenario for capture buffers.


## v1.11.0 - 2024-11-28
- Improved stability and performance of TEC control algorithm.
- Changed TEC,GAIN constants to be in dB.
- Enforced stability limitations on FAST and SLOW gains.
- OSD: Added current and coil dither settings.
- OSD: Fixed KI error raised in locking menu.
- OSD: Improved robustness of menu system to communications errors.
- OSD: Reduced jitter when redrawing menu.
- OSD: Fixed error messages raised in oscilloscope mode.
